#version 330 core

uniform sampler2D tex;
uniform vec4 color;

in float intensity;

layout (location = 0) out vec4 frag_color;

void main()
{
	const vec4 blue = vec4(53.f/255.0, 62.0/255.0, 93.0/255.0, 1.0);

	vec4 diff = texture(tex, gl_PointCoord).rrrr;
	if ( diff.r < 0.01 ) discard;
	frag_color = diff * blue * smoothstep(0.3, 1.0, max(intensity,0.0)) * color;
	//frag_color = vec4(1.0);
}
